import pygame

from OpenGL.GL import *
from OpenGL.GLU import *

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 3 - colors"
    self.glinited = False
  def initGL(self):
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST)
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,100.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glLoadIdentity()
    #triangle
    glTranslatef(-1.5,0.,-6.)
    glBegin(GL_TRIANGLES)
    glColor3f(1,0,0)
    glVertex3f(0.,1.,0.)
    glColor3f(0,1,0)
    glVertex3f(-1.,-1.,0.)
    glColor3f(0,0,1)
    glVertex3f(1.,-1.,0.)
    glEnd()
    #Square (Backfacing because of clockwise point order
    glColor3f(.5,.5,1)
    glTranslatef(3.,0.,0.)
    glBegin(GL_QUADS)
    glVertex3f(-1.,1.,0.)
    glVertex3f(1.,1.,0.)
    glVertex3f(1.,-1.,0.)
    glVertex3f(-1.,-1.,0.)
    glEnd()

screen = Screen()
screen.resize()

running = 1
while running:
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        screen.wi,screen.hi,screen.fullscreen=40,40,0
        screen.resize()
        
